@extends('index')

@section('content')





        <main>
                <!-- Hero Section -->
        <section class="hero-bg-dedicated text-white pt-20 pb-20 relative overflow-hidden">
            <div class="absolute inset-0 bg-gray-900 bg-opacity-80"></div>
            <div class="container mx-auto px-6 text-center relative z-10 flex flex-col items-center justify-center min-h-[340px] md:min-h-[420px]">
                <h1 class="text-5xl md:text-6xl font-extrabold leading-tight mb-4 drop-shadow-lg">Dedicated Wireless</h1>
                <p class="text-xl md:text-2xl text-gray-200 max-w-3xl mx-auto drop-shadow">Koneksi internet premium dengan jaminan bandwidth 1:1 dan Service Level Agreement (SLA) 99% untuk operasional bisnis tanpa henti.</p>
            </div>
        </section>

                <!-- Detail Manfaat -->
                <section class="py-20 bg-white">
                    <div class="container mx-auto px-6">
                         <div class="text-center mb-12" data-aos="fade-up">
                            <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Solusi Terbaik untuk Kebutuhan Bisnis</h2>
                            <p class="mt-4 text-lg text-gray-600 max-w-3xl mx-auto">Dari startup hingga korporasi, Dedicated Wireless MAJUIN memberikan fondasi konektivitas yang handal untuk pertumbuhan bisnis Anda.</p>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            <!-- Manfaat 1 -->
                            <div class="bg-gray-50 rounded-xl p-8 flex items-start gap-6" data-aos="fade-right">
                                <div class="bg-blue-100 text-blue-600 rounded-full w-16 h-16 flex-shrink-0 flex items-center justify-center text-2xl">
                                    <i class="fas fa-tachometer-alt"></i>
                                </div>
                                <div>
                                    <h3 class="text-xl font-bold mb-2">Jaminan Bandwidth 1:1</h3>
                                    <p class="text-gray-600">Kecepatan upload dan download simetris, ideal untuk video conference, transfer file besar, dan menjalankan aplikasi bisnis berbasis cloud tanpa hambatan.</p>
                                </div>
                            </div>
                             <!-- Manfaat 2 -->
                            <div class="bg-gray-50 rounded-xl p-8 flex items-start gap-6" data-aos="fade-left">
                                <div class="bg-blue-100 text-blue-600 rounded-full w-16 h-16 flex-shrink-0 flex items-center justify-center text-2xl">
                                   <i class="fas fa-shield-alt"></i>
                                </div>
                                <div>
                                    <h3 class="text-xl font-bold mb-2">Konektivitas Handal dengan SLA</h3>
                                    <p class="text-gray-600">Kami memberikan jaminan Service Level Agreement (SLA) uptime 99%, memastikan operasional bisnis Anda berjalan lancar dengan dukungan teknis prioritas.</p>
                                </div>
                            </div>
                             <!-- Manfaat 3 -->
                            <div class="bg-gray-50 rounded-xl p-8 flex items-start gap-6" data-aos="fade-right">
                                <div class="bg-blue-100 text-blue-600 rounded-full w-16 h-16 flex-shrink-0 flex items-center justify-center text-2xl">
                                   <i class="fas fa-rocket"></i>
                                </div>
                                <div>
                                    <h3 class="text-xl font-bold mb-2">Latensi Ultra Rendah</h3>
                                    <p class="text-gray-600">Koneksi yang sangat responsif dan stabil, sangat penting untuk aplikasi kritikal seperti Voice over IP (VoIP), streaming real-time, dan sistem trading online.</p>
                                </div>
                            </div>
                             <!-- Manfaat 4 -->
                            <div class="bg-gray-50 rounded-xl p-8 flex items-start gap-6" data-aos="fade-left">
                                <div class="bg-blue-100 text-blue-600 rounded-full w-16 h-16 flex-shrink-0 flex items-center justify-center text-2xl">
                                    <i class="fas fa-lock"></i>
                                </div>
                                <div>
                                    <h3 class="text-xl font-bold mb-2">Keamanan Jaringan Terjamin</h3>
                                    <p class="text-gray-600">Dapatkan alokasi IP publik statis dan jaringan yang terisolasi, memberikan lapisan keamanan tambahan untuk melindungi data sensitif perusahaan Anda.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Paket Dedicated -->
                <section id="dedicated-packages" class="py-20 bg-gray-50 dot-pattern">
                    <div class="container mx-auto px-6">
                        <div class="text-center mb-12" data-aos="fade-up">
                            <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Pilihan Paket Dedicated</h2>
                            <p class="mt-4 text-lg text-gray-600">Paket dengan performa terjamin untuk mendorong pertumbuhan bisnis Anda.</p>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                            <!-- Paket Business Pro -->
                            <div class="bg-white rounded-xl shadow-lg p-8 text-center flex flex-col transition-all duration-300 hover:shadow-2xl hover:scale-105" data-aos="fade-up" data-aos-delay="100">
                                <h3 class="text-2xl font-bold mb-2">Business Pro</h3>
                                <p class="text-5xl font-extrabold text-blue-600 my-3">25 <span class="text-xl font-medium">Mbps</span></p>
                                <ul class="space-y-3 text-gray-600 mb-8 flex-grow text-left">
                                    <li class="flex items-center"><i class="fas fa-check-circle text-blue-500 mr-3"></i>CIR 1:1 Symmetric</li>
                                    <li class="flex items-center"><i class="fas fa-check-circle text-blue-500 mr-3"></i>SLA Uptime 99%</li>
                                    <li class="flex items-center"><i class="fas fa-check-circle text-blue-500 mr-3"></i>1 IP Public Static</li>
                                    <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Prioritas Dukungan Teknis</li>
                                </ul>
                                <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20dengan%20paket%20Business%20Pro%2025%20Mbps." class="w-full mt-auto text-center bg-blue-100 text-blue-700 font-bold py-3 rounded-lg hover:bg-blue-200 transition-colors">Pilih Paket</a>
                            </div>
                             <!-- Paket Enterprise Prime -->
                            <div class="bg-white rounded-xl shadow-lg p-8 text-center flex flex-col transition-all duration-300 hover:shadow-2xl hover:scale-105" data-aos="fade-up" data-aos-delay="200">
                                <h3 class="text-2xl font-bold mb-2">Enterprise Prime</h3>
                                <p class="text-5xl font-extrabold text-blue-600 my-3">50 <span class="text-xl font-medium">Mbps</span></p>
                                <ul class="space-y-3 text-gray-600 mb-8 flex-grow text-left">
                                    <li class="flex items-center"><i class="fas fa-check-circle text-blue-500 mr-3"></i>CIR 1:1 Symmetric</li>
                                    <li class="flex items-center"><i class="fas fa-check-circle text-blue-500 mr-3"></i>SLA Uptime 99%</li>
                                    <li class="flex items-center"><i class="fas fa-check-circle text-blue-500 mr-3"></i>/29 IP Public Static</li>
                                    <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Prioritas Dukungan Teknis</li>
                                </ul>
                                <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20dengan%20paket%20Enterprise%20Prime%2050%20Mbps." class="w-full mt-auto text-center bg-blue-100 text-blue-700 font-bold py-3 rounded-lg hover:bg-blue-200 transition-colors">Pilih Paket</a>
                            </div>
                             <!-- Paket Corporate Elite -->
                            <div class="bg-white rounded-xl shadow-lg p-8 text-center flex flex-col border-2 border-blue-600 transform lg:scale-105 relative" data-aos="fade-up" data-aos-delay="300">
                                 <p class="absolute top-0 right-1/2 translate-x-1/2 -translate-y-1/2 bg-blue-600 text-white text-xs font-bold px-3 py-1 rounded-full">Best Value</p>
                                <h3 class="text-2xl font-bold mb-2">Corporate Elite</h3>
                                <p class="text-5xl font-extrabold text-blue-600 my-3">100 <span class="text-xl font-medium">Mbps</span></p>
                                <ul class="space-y-3 text-gray-600 mb-8 flex-grow text-left">
                                   <li class="flex items-center"><i class="fas fa-check-circle text-blue-500 mr-3"></i>CIR 1:1 Symmetric</li>
                                   <li class="flex items-center"><i class="fas fa-check-circle text-blue-500 mr-3"></i>SLA Uptime 99.5%</li>
                                   <li class="flex items-center"><i class="fas fa-check-circle text-blue-500 mr-3"></i>/28 IP Public Static</li>
                                   <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Dedicated Account Manager</li>
                                </ul>
                                <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20dengan%20paket%20Corporate%20Elite%20100%20Mbps." class="w-full mt-auto text-center bg-blue-600 text-white font-bold py-3 rounded-lg hover:bg-blue-700 transition-colors">Pilih Paket</a>
                            </div>
                             <!-- Paket Custom Enterprise -->
                            <div class="bg-white rounded-xl shadow-lg p-8 text-center flex flex-col transition-all duration-300 hover:shadow-2xl hover:scale-105" data-aos="fade-up" data-aos-delay="400">
                                <h3 class="text-2xl font-bold mb-2">Custom Enterprise</h3>
                                <p class="text-5xl font-extrabold text-blue-600 my-3">>100 <span class="text-xl font-medium">Mbps</span></p>
                                <ul class="space-y-3 text-gray-600 mb-8 flex-grow text-left">
                                     <li class="flex items-center"><i class="fas fa-check-circle text-blue-500 mr-3"></i>Bandwidth Fleksibel</li>
                                     <li class="flex items-center"><i class="fas fa-check-circle text-blue-500 mr-3"></i>Solusi BGP/Multi-homing</li>
                                     <li class="flex items-center"><i class="fas fa-check-circle text-blue-500 mr-3"></i>Layanan Managed Service</li>
                                     <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>SLA & Dukungan Khusus</li>
                                </ul>
                                <a href="https://wa.me/62817228297?text=Halo,%20saya%20ingin%20konsultasi%20paket%20Custom%20Enterprise." class="w-full mt-auto text-center bg-blue-100 text-blue-700 font-bold py-3 rounded-lg hover:bg-blue-200 transition-colors">Hubungi Kami</a>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Kenapa Memilih Wireless -->
                 <section class="py-20 bg-white">
                    <div class="container mx-auto px-6">
                         <div class="text-center mb-12" data-aos="fade-up">
                            <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Keunggulan Koneksi Wireless Dedicated</h2>
                            <p class="mt-4 text-lg text-gray-600 max-w-3xl mx-auto">Teknologi nirkabel kami menawarkan fleksibilitas dan keandalan yang tidak tertandingi untuk kebutuhan bisnis.</p>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                            <!-- Keuntungan 1 -->
                            <div class="text-center p-6" data-aos="fade-up" data-aos-delay="100">
                                <i class="fas fa-shipping-fast text-4xl text-blue-600 mb-4"></i>
                                <h3 class="text-xl font-bold mb-2">Implementasi Cepat</h3>
                                <p class="text-gray-600">Tanpa perlu penarikan kabel fiber optik yang rumit, proses instalasi di lokasi bisnis Anda menjadi jauh lebih cepat dan efisien.</p>
                            </div>
                            <!-- Keuntungan 2 -->
                            <div class="text-center p-6" data-aos="fade-up" data-aos-delay="200">
                                <i class="fas fa-map-signs text-4xl text-blue-600 mb-4"></i>
                                <h3 class="text-xl font-bold mb-2">Jangkauan Lebih Luas</h3>
                                <p class="text-gray-600">Teknologi wireless mampu menjangkau area-area bisnis dan industri yang belum tercover oleh jaringan kabel fiber optik.</p>
                            </div>
                            <!-- Keuntungan 3 -->
                            <div class="text-center p-6" data-aos="fade-up" data-aos-delay="300">
                                <i class="fas fa-cloud-showers-heavy text-4xl text-blue-600 mb-4"></i>
                                <h3 class="text-xl font-bold mb-2">Tahan Gangguan Fisik</h3>
                                <p class="text-gray-600">Jaringan kami tidak rentan terhadap risiko kabel putus akibat galian atau faktor eksternal lainnya, menjaga kontinuitas bisnis Anda.</p>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Q&A Section -->
                <section class="py-20 bg-gray-50 dot-pattern">
                    <div class="container mx-auto px-6">
                        <div class="text-center mb-12" data-aos="fade-up">
                            <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Pertanyaan Umum Dedicated</h2>
                        </div>
                        <div class="max-w-3xl mx-auto" data-aos="fade-up" data-aos-delay="100">
                            <div class="space-y-4">
                                <!-- Q1 -->
                                <div class="qa-item bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                                    <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-gray-800 focus:outline-none">
                                        <span class="text-lg">Apa itu internet dedicated dengan rasio 1:1?</span>
                                        <i class="fas fa-plus text-blue-600"></i>
                                    </button>
                                    <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                                        <div class="p-6 pt-0 text-gray-600">
                                            <p>Internet dedicated 1:1 (CIR) berarti Anda mendapatkan kecepatan upload dan download yang sama persis sesuai paket, tanpa dibagi dengan pengguna lain. Ini menjamin performa yang konsisten untuk aplikasi bisnis yang membutuhkan transfer data dua arah secara intensif.</p>
                                        </div>
                                    </div>
                                </div>
                                <!-- Q2 -->
                                <div class="qa-item bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                                    <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-gray-800 focus:outline-none">
                                        <span class="text-lg">Apa yang dimaksud dengan Service Level Agreement (SLA)?</span>
                                         <i class="fas fa-plus text-blue-600"></i>
                                    </button>
                                    <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                                        <div class="p-6 pt-0 text-gray-600">
                                            <p>SLA adalah kontrak jaminan tingkat layanan dari kami. Untuk paket dedicated, kami memberikan jaminan uptime jaringan hingga 99.5%, yang berarti koneksi Anda akan sangat jarang mengalami gangguan. Jika terjadi, kami memberikan penanganan prioritas dan kompensasi.</p>
                                        </div>
                                    </div>
                                </div>
                                <!-- Q3 -->
                                <div class="qa-item bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                                    <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-gray-800 focus:outline-none">
                                        <span class="text-lg">Berapa lama waktu yang dibutuhkan untuk instalasi?</span>
                                         <i class="fas fa-plus text-blue-600"></i>
                                    </button>
                                    <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                                        <div class="p-6 pt-0 text-gray-600">
                                           <p>Proses instalasi biasanya memakan waktu 3-7 hari kerja setelah survei lokasi selesai. Tim teknis kami akan memastikan semua perangkat terpasang dengan optimal untuk performa terbaik dan terintegrasi dengan jaringan yang ada.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Final CTA -->
                <section class="py-20 bg-white">
                    <div class="container mx-auto px-6">
                        <div class="bg-blue-600 text-white rounded-2xl p-10 flex flex-col lg:flex-row items-center justify-between gap-8" data-aos="zoom-in">
                            <div class="lg:w-2/3 text-center lg:text-left">
                                <h2 class="text-3xl font-bold mb-3">Siap Meningkatkan Konektivitas Bisnis Anda?</h2>
                                <p class="text-blue-100">Hubungi tim konsultan kami untuk mendapatkan penawaran terbaik dan survei lokasi gratis. Pastikan bisnis Anda didukung oleh koneksi internet yang handal.</p>
                            </div>
                            <div class="flex-shrink-0">
                                <a href="#" class="bg-white text-blue-700 font-bold px-8 py-4 rounded-lg hover:bg-gray-100 transition-colors transform hover:scale-105 shadow-lg inline-block">
                                    Jadwalkan Survei Gratis
                                </a>
                            </div>
                        </div>
                    </div>
                </section>
        
        </main>
        @endsection
