<?php $__env->startSection('title', 'MAJUIN - Internet Wireless Cepat & Stabil'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .hero-bg {
        background-color: #f0f7ff;
    }
    .package-bg {
        background: radial-gradient(circle at top left, #f3f4ff, #ffffff);
    }
    .qa-question.active {
        background-color: #374151;
    }
    .card-lift:hover {
        transform: translateY(-8px);
        box-shadow: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);
    }
    .feature-icon {
        transition: transform 0.3s ease;
    }
    .group:hover .feature-icon {
        transform: scale(1.2);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <section class="hero-bg pt-16 pb-8">
        <div class="container mx-auto px-6 flex flex-col md:flex-row items-center">
            <div class="md:w-1/2 text-center md:text-left mb-8 md:mb-0" data-aos="fade-right">
                <h1 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold text-gray-900 leading-tight mb-4">Butuh Internet Wireless <span id="typing-effect" class="text-blue-600"></span><br>Hubungi Kami Sekarang</h1>
                <p class="text-gray-600 text-lg mb-8">Tinggal pencet tombol, langsung terhubung tim kami yang siap memberikan informasi lengkap seputar paket, promo, hingga pemasangan di rumah Anda.</p>
                <a href="https://wa.me/62817228297?text=Halo,%20saya%20butuh%20bantuan%20Customer%20Service." class="bg-green-500 text-white font-bold text-lg px-6 sm:px-8 py-4 rounded-lg hover:bg-green-600 transition-all duration-300 transform hover:scale-105 shadow-lg inline-flex items-center">
                    <i class="fab fa-whatsapp mr-3 text-2xl"></i>
                     Hubungi Kami Sekarang
                </a>
            </div>
            <div class="md:w-1/2 relative flex justify-center" data-aos="fade-left">
                 <img src="<?php echo e(asset('aset/model.png')); ?>" alt="Model" class="max-w-sm md:max-w-md rounded-lg z-10" style="width: 350px; height: auto;" data-aos="zoom-in">
            </div>
        </div>
    </section>

    <!-- Pilihan Paket Broadband -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-6">
             <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Pilihan Paket Broadband Wireless</h2>
                <p class="mt-4 text-lg text-gray-600 max-w-3xl mx-auto">Pilihan Paket Broadband Wireless dari Majuin menghadirkan koneksi unlimited yang cepat dan stabil dengan kecepatan mulai 10 Mbps hingga 100 Mbps. Kami memberikan solusi terbaik untuk menunjang aktivitas online Anda.</p>
            </div>
            <div class="package-bg rounded-2xl px-4 py-8 md:p-12 flex flex-col-reverse lg:flex-row items-center gap-8" data-aos="fade-up">
                <div class="lg:w-2/5 text-gray-700">
                    <div class="bg-blue-800 text-white font-bold text-2xl py-2 px-6 rounded-t-lg inline-block">Spark</div>
                    <div class="flex flex-col md:flex-row md:items-end gap-6 md:gap-12 mb-8">
                        <div>
                            <p class="text-lg">up to</p>
                            <p class="text-6xl font-extrabold text-gray-900">10 <span class="text-3xl font-bold">Mbps</span></p>
                        </div>
                        <ul class="space-y-3">
                            <li class="flex items-center gap-3 group"><i class="fas fa-infinity text-blue-600 feature-icon"></i> Unlimited Tanpa FUP</li>
                            <li class="flex items-center gap-3 group"><i class="fas fa-wifi text-blue-600 feature-icon"></i> Sudah termasuk modem</li>
                            <li class="flex items-center gap-3 group"><i class="fas fa-mobile-alt text-blue-600 feature-icon"></i> Stabil 7 device</li>
                            <li class="flex items-center gap-3 group"><i class="fas fa-headset text-blue-600 feature-icon"></i> Customer Support</li>
                        </ul>
                    </div>
                    <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20untuk%20berlangganan%20paket%20Spark%2010%20Mbps." class="w-full text-center bg-gradient-to-r from-blue-600 to-indigo-600 text-white font-bold py-4 px-8 rounded-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105 block">Berlangganan Sekarang</a>
                </div>
                <div class="lg:w-3/5 flex justify-center lg:justify-end mb-8 lg:mb-0">
                    <img src="<?php echo e(asset('aset/modem.png')); ?>" alt="modem" class="max-w-md lg:max-w-lg" style="width:auto" data-aos="zoom-in" style="width: auto; height: auto;">
                </div>
            </div>
        </div>
    </section>

    <!-- Paket Lainnya -->
    <section class="py-16 bg-gray-50 dot-pattern">
        <div class="container mx-auto px-6">
             <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Paket Boost -->
                <div class="bg-white rounded-xl p-8 border-2 border-gray-200 text-center flex flex-col transition-all duration-300 card-lift" data-aos="fade-right">
                    <h3 class="text-2xl font-bold mb-2">Boost</h3>
                    <p class="text-5xl font-extrabold text-blue-600 my-3">15 <span class="text-xl font-medium">Mbps</span></p>
                    <ul class="space-y-3 text-gray-600 mt-6 mb-8 flex-grow text-left">
                        <li class="flex items-center"><i class="fas fa-wifi text-blue-500 mr-3"></i>Kecepatan simetris</li>
                        <li class="flex items-center"><i class="fas fa-infinity text-blue-500 mr-3"></i>Internet Tanpa FUP</li>
                        <li class="flex items-center"><i class="fas fa-tools text-blue-500 mr-3"></i>Gratis Biaya Instalasi</li>
                        <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Dukungan 24/7</li>
                    </ul>
                    <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20untuk%20berlangganan%20paket%20Boost%2015%20Mbps." class="w-full text-center bg-blue-600 text-white font-bold py-3 rounded-lg hover:bg-blue-700 transition-colors">Berlangganan Sekarang</a>
                </div>
                <!-- Paket Turbo -->
                <div class="bg-white rounded-xl p-8 border-2 border-blue-600 text-center flex flex-col transform lg:scale-105 transition-all duration-300 card-lift" data-aos="fade-up">
                     <h3 class="text-2xl font-bold mb-2">Turbo</h3>
                    <p class="text-5xl font-extrabold text-blue-600 my-3">20 <span class="text-xl font-medium">Mbps</span></p>
                     <ul class="space-y-3 text-gray-600 mt-6 mb-8 flex-grow text-left">
                        <li class="flex items-center"><i class="fas fa-wifi text-blue-500 mr-3"></i>Kecepatan simetris</li>
                        <li class="flex items-center"><i class="fas fa-infinity text-blue-500 mr-3"></i>Internet Tanpa FUP</li>
                        <li class="flex items-center"><i class="fas fa-tools text-blue-500 mr-3"></i>Gratis Biaya Instalasi</li>
                        <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Dukungan 24/7</li>
                    </ul>
                    <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20untuk%20berlangganan%20paket%20Turbo%2020%20Mbps." class="w-full text-center bg-blue-600 text-white font-bold py-3 rounded-lg hover:bg-blue-700 transition-colors">Berlangganan Sekarang</a>
                </div>
                <!-- Paket Velocity -->
                <div class="bg-white rounded-xl p-8 border-2 border-gray-200 text-center flex flex-col transition-all duration-300 card-lift" data-aos="fade-left">
                     <h3 class="text-2xl font-bold mb-2">Velocity</h3>
                    <p class="text-5xl font-extrabold text-blue-600 my-3">30 <span class="text-xl font-medium">Mbps</span></p>
                     <ul class="space-y-3 text-gray-600 mt-6 mb-8 flex-grow text-left">
                        <li class="flex items-center"><i class="fas fa-wifi text-blue-500 mr-3"></i>Kecepatan simetris</li>
                        <li class="flex items-center"><i class="fas fa-infinity text-blue-500 mr-3"></i>Internet Tanpa FUP</li>
                        <li class="flex items-center"><i class="fas fa-tools text-blue-500 mr-3"></i>Gratis Biaya Instalasi</li>
                        <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Dukungan 24/7</li>
                    </ul>
                    <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20untuk%20berlangganan%20paket%20Velocity%2030%20Mbps." class="w-full text-center bg-blue-600 text-white font-bold py-3 rounded-lg hover:bg-blue-700 transition-colors">Berlangganan Sekarang</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Solusi Dedicated Wireless -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-6">
             <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Dedicated Wireless (Untuk Bisnis)</h2>
                <p class="mt-4 text-lg text-gray-600 max-w-3xl mx-auto">Layanan premium dengan performa terjamin untuk operasional bisnis yang andal. Hubungi kami untuk mendapatkan penawaran yang disesuaikan.</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <div class="bg-gray-50 p-8 rounded-xl text-center" data-aos="fade-up" data-aos-delay="100">
                    <i class="fas fa-exchange-alt text-4xl text-blue-600 mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Bandwidth Simetris 1:1</h3>
                    <p class="text-gray-600">Kecepatan download dan upload yang sama persis dan tidak terbagi.</p>
                </div>
                <div class="bg-gray-50 p-8 rounded-xl text-center" data-aos="fade-up" data-aos-delay="200">
                    <i class="fas fa-shield-alt text-4xl text-blue-600 mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Jaminan Uptime 99%</h3>
                    <p class="text-gray-600">Jaminan konektivitas melalui SLA untuk memastikan bisnis Anda selalu online.</p>
                </div>
                <div class="bg-gray-50 p-8 rounded-xl text-center" data-aos="fade-up" data-aos-delay="300">
                    <i class="fas fa-globe-asia text-4xl text-blue-600 mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">IP Publik Statis</h3>
                    <p class="text-gray-600">Alamat IP khusus untuk kebutuhan server, VPN, atau akses jarak jauh lainnya.</p>
                </div>
                <div class="bg-gray-50 p-8 rounded-xl text-center" data-aos="fade-up" data-aos-delay="400">
                    <i class="fas fa-user-shield text-4xl text-blue-600 mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Prioritas Dukungan 24/7</h3>
                    <p class="text-gray-600">Tim support khusus yang siap memberikan penanganan prioritas untuk Anda.</p>
                </div>
            </div>
            <div class="text-center mt-12" data-aos="fade-up" data-aos-delay="500">
                 <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20dengan%20layanan%20Dedicated%20Wireless%20untuk%20bisnis." class="bg-blue-600 text-white font-bold px-8 py-4 rounded-lg hover:bg-blue-700 transition-colors transform hover:scale-105 shadow-lg inline-block">
                    Diskusikan Kebutuhan Bisnis Anda
                </a>
            </div>
        </div>
    </section>

    <!-- Ringkasan Info -->
    <section class="py-20 bg-gray-50 dot-pattern">
        <div class="container mx-auto px-6">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="bg-white p-8 rounded-lg shadow-md" data-aos="fade-up">
                    <h3 class="text-2xl font-bold text-gray-900 mb-4">Tentang Kami</h3>
                    <p class="text-gray-600 mb-6">MAJUIN adalah penyedia jasa internet wireless resmi yang berdedikasi untuk memberdayakan masyarakat Sukabumi melalui konektivitas digital yang andal.</p>
                    <a href="<?php echo e(url('/tentang')); ?>" class="font-semibold text-blue-600 hover:underline">Pelajari Lebih Lanjut &rarr;</a>
                </div>
                <div class="bg-white p-8 rounded-lg shadow-md" data-aos="fade-up" data-aos-delay="100">
                    <h3 class="text-2xl font-bold text-gray-900 mb-4">Layanan Kami</h3>
                    <p class="text-gray-600 mb-6">Kami menawarkan dua solusi utama: Broadband Wireless untuk kebutuhan rumahan dan Dedicated Wireless untuk performa bisnis yang terjamin.</p>
                    <a href="<?php echo e(url('/layanan')); ?>" class="font-semibold text-blue-600 hover:underline">Lihat Semua Layanan &rarr;</a>
                </div>
                <div class="bg-white p-8 rounded-lg shadow-md" data-aos="fade-up" data-aos-delay="200">
                    <h3 class="text-2xl font-bold text-gray-900 mb-4">Hubungi Kami</h3>
                    <p class="text-gray-600 mb-6">Punya pertanyaan atau siap berlangganan? Tim kami siap membantu Anda melalui WhatsApp atau telepon.</p>
                    <a href="<?php echo e(url('/kontak')); ?>" class="font-semibold text-blue-600 hover:underline">Info Kontak &rarr;</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Mitra & Teknologi Pendukung -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-6 text-center">
            <div class="flex flex-wrap justify-center items-center gap-x-12 sm:gap-x-16 gap-y-8" data-aos="fade-up" data-aos-delay="200">
                <img src="<?php echo e(asset('logo/thc.png')); ?>" class="h-10 md:h-12 grayscale hover:grayscale-0 transition-all duration-300 cursor-pointer">
                <img src="<?php echo e(asset('logo/fiberstar.png')); ?>" alt="Logo Mitra 2" class="h-10 md:h-12 grayscale hover:grayscale-0 transition-all duration-300 cursor-pointer">
                <img src="<?php echo e(asset('logo/komdigi.png')); ?>" alt="Logo Mitra 3" class="h-10 md:h-12 grayscale hover:grayscale-0 transition-all duration-300 cursor-pointer">
                <img src="<?php echo e(asset('logo/apji.png')); ?>" alt="Logo Mitra 4" class="h-10 md:h-12 grayscale hover:grayscale-0 transition-all duration-300 cursor-pointer">
                <img src="<?php echo e(asset('logo/idnic.png')); ?>" alt="Logo Mitra 5" class="h-10 md:h-12 grayscale hover:grayscale-0 transition-all duration-300 cursor-pointer">
            </div>
        </div>
    </section>

    <!-- Tim Support & Q&A -->
    <section class="relative py-20 bg-gray-800 text-white overflow-hidden">
         <div class="absolute inset-0 bg-gray-800 opacity-90"></div>
        <div class="container mx-auto px-6 relative z-10">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <div data-aos="fade-right">
                     <h2 class="text-4xl font-bold mb-8 text-center lg:text-left">Pertanyaan Umum</h2>
                     <div class="space-y-4">
                        <div class="qa-item bg-gray-700 rounded-lg overflow-hidden">
                            <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-white focus:outline-none transition-colors duration-300">
                                <span class="text-lg">Bagaimana cara berlangganan?</span>
                                <i class="fas fa-plus"></i>
                            </button>
                            <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                                <div class="p-6 pt-0 text-gray-300">
                                    <p>Cukup hubungi tim marketing kami melalui tombol WhatsApp yang tersedia, tim kami akan memandu Anda melalui proses survey lokasi hingga instalasi.</p>
                                </div>
                            </div>
                        </div>
                        <div class="qa-item bg-gray-700 rounded-lg overflow-hidden">
                            <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-white focus:outline-none transition-colors duration-300">
                                <span class="text-lg">Apa beda Broadband & Dedicated?</span>
                                 <i class="fas fa-plus"></i>
                            </button>
                            <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                                <div class="p-6 pt-0 text-gray-300">
                                    <p>Broadband ideal untuk rumahan dengan bandwidth yang dibagi, sedangkan Dedicated untuk bisnis dengan bandwidth eksklusif 1:1 dan jaminan SLA.</p>
                                </div>
                            </div>
                        </div>
                        <div class="qa-item bg-gray-700 rounded-lg overflow-hidden">
                            <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-white focus:outline-none transition-colors duration-300">
                                <span class="text-lg">Apakah ada FUP?</span>
                                 <i class="fas fa-plus"></i>
                            </button>
                            <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                                <div class="p-6 pt-0 text-gray-300">
                                    <p>Tidak. Semua paket internet Broadband kami sepenuhnya unlimited tanpa Batas Pemakaian Wajar (FUP).</p>
                                </div>
                            </div>
                        </div>
                         <div class="qa-item bg-gray-700 rounded-lg overflow-hidden">
                            <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-white focus:outline-none transition-colors duration-300">
                                <span class="text-lg">Apakah ada kontrak berlangganan?</span>
                                <i class="fas fa-plus"></i>
                            </button>
                            <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                                <div class="p-6 pt-0 text-gray-300">
                                    <p>Kami menawarkan fleksibilitas. Ada pilihan paket dengan kontrak untuk mendapatkan harga terbaik, dan ada juga paket tanpa kontrak. Silakan diskusikan dengan tim sales kami untuk menemukan opsi yang paling sesuai.</p>
                                </div>
                            </div>
                        </div>
                         <div class="qa-item bg-gray-700 rounded-lg overflow-hidden">
                            <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-white focus:outline-none transition-colors duration-300">
                                <span class="text-lg">Bagaimana sistem pembayarannya?</span>
                                 <i class="fas fa-plus"></i>
                            </button>
                            <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                                <div class="p-6 pt-0 text-gray-300">
                                    <p>Pembayaran dilakukan setiap bulan sesuai tanggal aktivasi. Kami menyediakan berbagai metode pembayaran yang mudah, termasuk transfer bank, virtual account, dan dompet digital.</p>
                                </div>
                            </div>
                        </div>
                     </div>
                </div>
                <div class="text-center" data-aos="fade-left">
                    <h2 class="text-4xl font-bold mb-4">Hubungi Tim Customer Support Kami</h2>
                    <p class="text-gray-300 mb-8">Tim kami selalu siap membantu Anda. Jangan ragu untuk bertanya mengenai layanan, paket, atau kendala teknis yang Anda hadapi.</p>
                     <img src="<?php echo e(asset('aset/cs1.png')); ?>" alt="Tim Support" class="rounded-xl shadow-2xl mt-8 mx-auto">
                     <a href="#" class="bg-green-500 text-white font-bold text-lg px-8 py-3 rounded-lg hover:bg-green-600 transition-all duration-300 transform hover:scale-105 shadow-lg inline-flex items-center mt-8">
                        <i class="fab fa-whatsapp mr-3"></i>
                        Hubungi Tim Support
                    </a>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Final CTA -->
    <section class="bg-slate-900 text-white">
        <div class="container mx-auto px-6 py-20 text-center">
            <h2 class="text-4xl font-bold mb-6" data-aos="fade-up">Mulai Produktivitas Anda Dengan Majuin</h2>
            <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20untuk%20mendaftar%20internet." class="bg-blue-600 text-white font-bold px-8 py-3 rounded-lg hover:bg-blue-700 transition-colors relative transform hover:scale-105" data-aos="fade-up" data-aos-delay="100">
                Daftar Sekarang
            </a>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        if (document.getElementById('typing-effect')) {
            new TypeIt('#typing-effect', {
                strings: ['Cepat?', 'Stabil?', 'Unlimited?'],
                speed: 200,
                breakLines: false,
                autoStart: true,
                loop: true,
            }).go();
        }

        const qaItems = document.querySelectorAll('.qa-item');
        qaItems.forEach(item => {
            const question = item.querySelector('.qa-question');
            const answer = item.querySelector('.qa-answer');
            const icon = question.querySelector('i');

            question.addEventListener('click', () => {
                const isOpen = answer.style.maxHeight && answer.style.maxHeight !== '0px';

                qaItems.forEach(otherItem => {
                    if (otherItem !== item) {
                        otherItem.querySelector('.qa-answer').style.maxHeight = '0px';
                        otherItem.querySelector('.qa-question').classList.remove('active');
                        const otherIcon = otherItem.querySelector('.qa-question i');
                        otherIcon.classList.remove('fa-minus');
                        otherIcon.classList.add('fa-plus');
                        otherIcon.style.transform = 'rotate(0deg)';
                    }
                });

                if (isOpen) {
                    answer.style.maxHeight = '0px';
                    question.classList.remove('active');
                    icon.classList.remove('fa-minus');
                    icon.classList.add('fa-plus');
                    icon.style.transform = 'rotate(0deg)';
                } else {
                    answer.style.maxHeight = answer.scrollHeight + 'px';
                    question.classList.add('active');
                    icon.classList.remove('fa-plus');
                    icon.classList.add('fa-minus');
                    icon.style.transform = 'rotate(180deg)';
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/lab-mji/Pictures/new/mji_isp/resources/views/index.blade.php ENDPATH**/ ?>