<?php $__env->startSection('title', 'Kontak Kami - MAJUIN'); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
<style>
    .swiper-slide {
        position: relative;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .swiper-slide::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(17, 24, 39, 0.85);
        z-index: 1;
    }
    .slide-content {
        position: relative;
        z-index: 2;
    }
    #chat-messages::-webkit-scrollbar {
      width: 6px;
    }
    #chat-messages::-webkit-scrollbar-track {
      background: #f1f1f1;
    }
    #chat-messages::-webkit-scrollbar-thumb {
      background: #888;
      border-radius: 3px;
    }
    #chat-messages::-webkit-scrollbar-thumb:hover {
      background: #555;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section with Slider -->
    <section class="relative h-[450px] text-white">
        <div class="swiper-container h-full">
            <div class="swiper-wrapper">
                <!-- Slide 1 -->
                <div class="swiper-slide bg-cover bg-center" style="background-image: url('https://images.pexels.com/photos/3184431/pexels-photo-3184431.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1');">
                    <div class="slide-content container mx-auto px-6 text-center">
                        <h1 class="text-4xl md:text-5xl font-extrabold leading-tight mb-4">Hubungi Kami</h1>
                        <p class="text-lg text-gray-300 max-w-2xl mx-auto">Punya pertanyaan atau butuh bantuan? Tim kami siap membantu Anda.</p>
                    </div>
                </div>
                <!-- Slide 2 -->
                <div class="swiper-slide bg-cover bg-center" style="background-image: url('https://images.pexels.com/photos/5926382/pexels-photo-5926382.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1');">
                    <div class="slide-content container mx-auto px-6 text-center">
                        <h1 class="text-4xl md:text-5xl font-extrabold leading-tight mb-4">Punya Pertanyaan Seputar Paket?</h1>
                        <p class="text-lg text-gray-300 max-w-2xl mx-auto">Tim sales kami siap memberikan informasi detail mengenai semua layanan kami.</p>
                    </div>
                </div>
                <!-- Slide 3 -->
                <div class="swiper-slide bg-cover bg-center" style="background-image: url('https://images.pexels.com/photos/3184465/pexels-photo-3184465.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1');">
                    <div class="slide-content container mx-auto px-6 text-center">
                        <h1 class="text-4xl md:text-5xl font-extrabold leading-tight mb-4">Butuh Bantuan Teknis?</h1>
                        <p class="text-lg text-gray-300 max-w-2xl mx-auto">Dukungan pelanggan kami tersedia 24/7 untuk menyelesaikan kendala Anda.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Kontak per Departemen -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-6">
            <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Hubungi Departemen yang Tepat</h2>
                <p class="mt-4 text-lg text-gray-600">Temukan kontak yang paling sesuai dengan kebutuhan Anda.</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Sales -->
                <div class="bg-gray-50 rounded-lg p-8 text-center" data-aos="fade-up" data-aos-delay="100">
                    <i class="fas fa-shopping-cart text-4xl text-blue-600 mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Penjualan & Pendaftaran</h3>
                    <p class="text-gray-600 mb-4">Untuk calon pelanggan baru, informasi paket, dan pendaftaran.</p>
                    <a href="https://wa.me/62817228297?text=Halo%20MAJUIN,%20saya%20tertarik%20dengan%20layanan%20pendaftaran." target="_blank" rel="noopener noreferrer" class="font-semibold text-blue-600 hover:underline inline-flex items-center gap-2">
                        <i class="fab fa-whatsapp"></i> Hubungi via WhatsApp
                    </a>
                </div>
                <!-- Support -->
                <div class="bg-gray-50 rounded-lg p-8 text-center" data-aos="fade-up" data-aos-delay="200">
                    <i class="fas fa-headset text-4xl text-blue-600 mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Dukungan Teknis</h3>
                    <p class="text-gray-600 mb-4">Untuk pelanggan yang mengalami kendala teknis atau gangguan.</p>
                    <a href="https://wa.me/62817228297?text=Halo%20MAJUIN,%20saya%20butuh%20bantuan%20teknis." target="_blank" rel="noopener noreferrer" class="font-semibold text-blue-600 hover:underline inline-flex items-center gap-2">
                        <i class="fab fa-whatsapp"></i> Hubungi via WhatsApp
                    </a>
                </div>
                <!-- Billing -->
                <div class="bg-gray-50 rounded-lg p-8 text-center" data-aos="fade-up" data-aos-delay="300">
                    <i class="fas fa-file-invoice-dollar text-4xl text-blue-600 mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Penagihan & Pembayaran</h3>
                    <p class="text-gray-600 mb-4">Untuk pertanyaan seputar tagihan, pembayaran, dan konfirmasi.</p>
                    <a href="https://wa.me/62817228297?text=Halo%20MAJUIN,%20saya%20ingin%20bertanya%20tentang%20tagihan." target="_blank" rel="noopener noreferrer" class="font-semibold text-blue-600 hover:underline inline-flex items-center gap-2">
                        <i class="fab fa-whatsapp"></i> Hubungi via WhatsApp
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Formulir Kontak & Peta -->
    <section class="py-20 bg-gray-50 dot-pattern">
        <div class="container mx-auto px-6">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-start">
                <!-- Formulir Kontak -->
                <div data-aos="fade-right">
                    <h2 class="text-3xl font-bold mb-6">Kirim Pesan Langsung</h2>
                    <form action="mailto:salam@majuin.co.id" method="POST" enctype="text/plain" class="space-y-6 bg-white p-8 rounded-lg shadow-md">
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700">Nama Lengkap</label>
                            <input type="text" name="Nama" id="name" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label for="email" class="block text-sm font-medium text-gray-700">Alamat Email</label>
                            <input type="email" name="Email" id="email" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label for="subject" class="block text-sm font-medium text-gray-700">Subjek</label>
                            <input type="text" name="Subjek" id="subject" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label for="message" class="block text-sm font-medium text-gray-700">Pesan Anda</label>
                            <textarea name="Pesan" id="message" rows="4" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"></textarea>
                        </div>
                        <div>
                            <button type="submit" class="w-full bg-blue-600 text-white font-bold py-3 px-6 rounded-lg hover:bg-blue-700 transition-colors">
                                Kirim Pesan
                            </button>
                        </div>
                    </form>
                </div>
                <!-- Peta & Info -->
                <div data-aos="fade-left">
                    <h2 class="text-3xl font-bold mb-6">Kunjungi Kantor Kami</h2>
                    <iframe 
                        width="100%" 
                        height="350" 
                        style="border:0" 
                        loading="lazy" 
                        allowfullscreen 
                        referrerpolicy="no-referrer-when-downgrade" 
                        src="https://maps.google.com/maps?q=-6.818831782528247,106.7586571357641&hl=id&z=16&amp;output=embed"
                        class="rounded-xl shadow-2xl w-full mb-6">
                    </iframe>
                    <div class="space-y-4">
                         <div class="flex items-start gap-4">
                            <i class="fas fa-map-marker-alt text-xl text-blue-600 mt-1"></i>
                            <div>
                                <h3 class="font-bold text-lg">Alamat Kantor</h3>
                                <p class="text-gray-600">Bumi Mutiara Indah No. D10, RT.2/RW.7, Kompa, Parungkuda, Kabupaten Sukabumi, Jawa Barat 43357</p>
                            </div>
                        </div>
                         <div class="flex items-start gap-4">
                            <i class="fas fa-clock text-xl text-blue-600 mt-1"></i>
                            <div>
                                <h3 class="font-bold text-lg">Jam Operasional</h3>
                                <p class="text-gray-600">Senin - Minggu: 08:00 - 17:00 WIB</p>
                                <a href="https://maps.app.goo.gl/rCtUJWEUkiezaMXV8">
                                    <button class="inline-block bg-blue-600 text-white font-bold py-2 px-4 rounded hover:bg-blue-700 transition-colors">Buka di Google Maps</button>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    <!-- Kenapa Memilih Kami -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-6">
            <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Kenapa Anda Bisa Mempercayai Kami?</h2>
                <p class="mt-4 text-lg text-gray-600 max-w-2xl mx-auto">Kami berkomitmen penuh pada kepuasan dan kepercayaan Anda.</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <div class="text-center" data-aos="fade-up" data-aos-delay="100">
                    <div class="bg-green-100 text-green-600 rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-4 text-3xl">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-2">ISP Resmi & Berlisensi</h3>
                    <p class="text-gray-600">Kami adalah penyelenggara jasa internet yang terdaftar dan beroperasi secara legal di bawah pengawasan pemerintah.</p>
                </div>
                <div class="text-center" data-aos="fade-up" data-aos-delay="200">
                    <div class="bg-green-100 text-green-600 rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-4 text-3xl">
                        <i class="fas fa-users-cog"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Tim Profesional & Lokal</h3>
                    <p class="text-gray-600">Tim kami terdiri dari para ahli lokal yang memahami kondisi area Anda dan siap memberikan pelayanan terbaik.</p>
                </div>
                <div class="text-center" data-aos="fade-up" data-aos-delay="300">
                    <div class="bg-green-100 text-green-600 rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-4 text-3xl">
                       <i class="fas fa-headset"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Dukungan Penuh 24/7</h3>
                    <p class="text-gray-600">Kami tidak akan membiarkan Anda sendirian. Tim support kami selalu siaga 24/7 untuk membantu setiap kendala yang Anda hadapi.</p>
                </div>
                <div class="text-center" data-aos="fade-up" data-aos-delay="400">
                    <div class="bg-green-100 text-green-600 rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-4 text-3xl">
                       <i class="fas fa-receipt"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Tanpa Biaya Tersembunyi</h3>
                    <p class="text-gray-600">Kami percaya pada transparansi. Semua biaya akan dijelaskan di awal tanpa ada tambahan biaya tak terduga di kemudian hari.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Singkat -->
    <section class="py-20 bg-gray-50 dot-pattern">
        <div class="container mx-auto px-6">
            <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Cek Pertanyaan Umum</h2>
                 <p class="mt-4 text-lg text-gray-600">Mungkin jawaban yang Anda cari ada di sini.</p>
            </div>
            <div class="max-w-3xl mx-auto" data-aos="fade-up" data-aos-delay="100">
                <div class="space-y-4">
                    <div class="qa-item bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                        <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-gray-800 focus:outline-none">
                            <span class="text-lg">Bagaimana cara mengecek area jangkauan?</span>
                            <i class="fas fa-plus text-blue-600"></i>
                        </button>
                        <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                            <div class="p-6 pt-0 text-gray-600">
                                <p>Cara terbaik adalah dengan menghubungi tim penjualan kami melalui WhatsApp atau telepon. Tim kami akan segera melakukan pengecekan berdasarkan alamat lengkap Anda.</p>
                            </div>
                        </div>
                    </div>
                    <div class="qa-item bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                        <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-gray-800 focus:outline-none">
                            <span class="text-lg">Berapa lama proses dari pendaftaran hingga internet aktif?</span>
                             <i class="fas fa-plus text-blue-600"></i>
                        </button>
                        <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                            <div class="p-6 pt-0 text-gray-600">
                                <p>Jika lokasi Anda sudah terjangkau, prosesnya sangat cepat. Setelah survey lokasi (biasanya di hari yang sama atau H+1), instalasi bisa dijadwalkan dan biasanya selesai dalam 2-4 jam.</p>
                            </div>
                        </div>
                    </div>
                    <div class="qa-item bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                        <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-gray-800 focus:outline-none">
                            <span class="text-lg">Apa saja metode pembayaran yang tersedia?</span>
                             <i class="fas fa-plus text-blue-600"></i>
                        </button>
                        <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                           <p class="p-6 pt-0 text-gray-600">Kami menyediakan berbagai metode pembayaran yang mudah, termasuk transfer bank (Virtual Account), dompet digital (GoPay, OVO, Dana), dan pembayaran melalui Alfamart/Indomaret.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const swiper = new Swiper('.swiper-container', {
            loop: true,
            effect: 'fade',
            autoplay: {
                delay: 4000,
                disableOnInteraction: false,
            },
        });

        const qaItems = document.querySelectorAll('.qa-item');
        qaItems.forEach(item => {
            const question = item.querySelector('.qa-question');
            const answer = item.querySelector('.qa-answer');
            const icon = question.querySelector('i');

            question.addEventListener('click', () => {
                const isOpen = answer.style.maxHeight && answer.style.maxHeight !== '0px';

                qaItems.forEach(otherItem => {
                    if (otherItem !== item) {
                        otherItem.querySelector('.qa-answer').style.maxHeight = '0px';
                        const otherIcon = otherItem.querySelector('.qa-question i');
                        otherIcon.classList.remove('fa-minus');
                        otherIcon.classList.add('fa-plus');
                    }
                });

                if (isOpen) {
                    answer.style.maxHeight = '0px';
                    icon.classList.remove('fa-minus');
                    icon.classList.add('fa-plus');
                } else {
                    answer.style.maxHeight = answer.scrollHeight + 'px';
                    icon.classList.remove('fa-plus');
                    icon.classList.add('fa-minus');
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/lab-mji/Pictures/new/mji_isp/resources/views/kontak.blade.php ENDPATH**/ ?>