<?php $__env->startSection('content'); ?>
	<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Broadband Wireless - Internet Cepat untuk Rumah | MAJUIN</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <link rel="stylesheet" href="https://unpkg.com/aos@next/dist/aos.css" />
    <link rel="shortcut icon" href="https://placehold.co/32x32/3B82F6/FFFFFF?text=M">
    <style>
        html, body {
            width: 100%;
            overflow-x: hidden;
            font-family: 'Inter', sans-serif;
        }
        .hero-bg-broadband {
            background-image: 
                linear-gradient(to right, rgba(17, 24, 39, 0.9), rgba(17, 24, 39, 0.75)),
                url('https://images.pexels.com/photos/4348404/pexels-photo-4348404.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1');
            background-size: cover;
            background-position: center;
        }
        .dot-pattern {
            background-image: radial-gradient(circle at 1px 1px, rgba(0,0,0,0.04) 1px, transparent 0);
            background-size: 25px 25px;
        }
        .qa-question i, #mobile-layanan-button i, #desktop-layanan-button i {
            transition: transform 0.3s ease;
        }
        .rotate-180 {
            transform: rotate(180deg);
        }
        /* Transisi untuk chat options */
        #chat-options {
            transition: opacity 0.3s ease-out, transform 0.3s ease-out;
        }
    </style>
</head>
<body class="bg-white text-gray-800">

    <main>
        <!-- Hero Section -->
        <section class="hero-bg-broadband text-white pt-20 pb-20">
            <div class="container mx-auto px-6 text-center" data-aos="fade-up">
                <h1 class="text-4xl md:text-5xl font-extrabold leading-tight mb-4">Broadband Wireless</h1>
                <p class="text-lg text-gray-300 max-w-2xl mx-auto">Koneksi internet cepat, stabil, dan terjangkau untuk seluruh kebutuhan digital keluarga Anda.</p>
            </div>
        </section>

        <!-- Detail Manfaat -->
        <section class="py-20 bg-white">
            <div class="container mx-auto px-6">
                 <div class="text-center mb-12" data-aos="fade-up">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Sempurna untuk Kebutuhan di Rumah</h2>
                    <p class="mt-4 text-lg text-gray-600 max-w-2xl mx-auto">Dari hiburan hingga produktivitas, Broadband Wireless MAJUIN mendukung semua aktivitas online Anda.</p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <!-- Manfaat 1 -->
                    <div class="bg-gray-50 rounded-xl p-8 flex items-start gap-6" data-aos="fade-right">
                        <div class="bg-blue-100 text-blue-600 rounded-full w-16 h-16 flex-shrink-0 flex items-center justify-center text-2xl">
                            <i class="fas fa-film"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold mb-2">Streaming Tanpa Batas</h3>
                            <p class="text-gray-600">Nikmati tayangan favorit di Netflix, YouTube, atau platform lainnya dalam resolusi tinggi tanpa terganggu buffering. Koneksi stabil kami memastikan pengalaman menonton yang mulus.</p>
                        </div>
                    </div>
                     <!-- Manfaat 2 -->
                    <div class="bg-gray-50 rounded-xl p-8 flex items-start gap-6" data-aos="fade-left">
                        <div class="bg-blue-100 text-blue-600 rounded-full w-16 h-16 flex-shrink-0 flex items-center justify-center text-2xl">
                           <i class="fas fa-graduation-cap"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold mb-2">Belajar & Bekerja dari Rumah</h3>
                            <p class="text-gray-600">Andal untuk mendukung kegiatan sekolah online, video conference via Zoom atau Google Meet, serta mengirim dan menerima file pekerjaan berukuran besar dengan cepat.</p>
                        </div>
                    </div>
                     <!-- Manfaat 3 -->
                    <div class="bg-gray-50 rounded-xl p-8 flex items-start gap-6" data-aos="fade-right">
                        <div class="bg-blue-100 text-blue-600 rounded-full w-16 h-16 flex-shrink-0 flex items-center justify-center text-2xl">
                           <i class="fas fa-gamepad"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold mb-2">Game Online Lebih Seru</h3>
                            <p class="text-gray-600">Dengan latensi yang rendah (ping kecil), Anda bisa bermain game online kompetitif tanpa lag yang mengganggu. Raih kemenangan dengan koneksi yang responsif.</p>
                        </div>
                    </div>
                     <!-- Manfaat 4 -->
                    <div class="bg-gray-50 rounded-xl p-8 flex items-start gap-6" data-aos="fade-left">
                        <div class="bg-blue-100 text-blue-600 rounded-full w-16 h-16 flex-shrink-0 flex items-center justify-center text-2xl">
                            <i class="fas fa-wifi"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold mb-2">Menghubungkan Seluruh Rumah</h3>
                            <p class="text-gray-600">Satu koneksi untuk semua perangkat, mulai dari smartphone, laptop, Smart TV, hingga perangkat smart home lainnya. Semua bisa terhubung secara bersamaan.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Paket Broadband -->
        <section id="broadband-packages" class="py-20 bg-gray-50 dot-pattern">
            <div class="container mx-auto px-6">
                <div class="text-center mb-12" data-aos="fade-up">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Pilihan Paket Broadband</h2>
                    <p class="mt-4 text-lg text-gray-600">Empat paket terbaik yang kami tawarkan untuk Anda.</p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                    <!-- Paket 10 Mbps -->
                    <div class="bg-white rounded-xl shadow-lg p-8 text-center flex flex-col transition-all duration-300 hover:shadow-2xl hover:scale-105" data-aos="fade-up" data-aos-delay="100">
                        <h3 class="text-2xl font-bold mb-2">Spark</h3>
                        <p class="text-5xl font-extrabold text-blue-600 my-3">10 <span class="text-xl font-medium">Mbps</span></p>
                        <ul class="space-y-3 text-gray-600 mb-8 flex-grow text-left">
                            <li class="flex items-center"><i class="fas fa-users text-blue-500 mr-3"></i>Ideal untuk 1-3 orang</li>
                            <li class="flex items-center"><i class="fas fa-film text-blue-500 mr-3"></i>Streaming Kualitas HD</li>
                            <li class="flex items-center"><i class="fas fa-globe text-blue-500 mr-3"></i>Browsing & Sosmed</li>
                            <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Dukungan Teknis 24/7</li>
                        </ul>
                        <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20untuk%20berlangganan%20paket%20Spark%2010%20Mbps." class="w-full mt-auto text-center bg-blue-100 text-blue-700 font-bold py-3 rounded-lg hover:bg-blue-200 transition-colors">Pilih Paket</a>
                    </div>
                     <!-- Paket 15 Mbps -->
                    <div class="bg-white rounded-xl shadow-lg p-8 text-center flex flex-col transition-all duration-300 hover:shadow-2xl hover:scale-105" data-aos="fade-up" data-aos-delay="200">
                        <h3 class="text-2xl font-bold mb-2">Boost</h3>
                        <p class="text-5xl font-extrabold text-blue-600 my-3">15 <span class="text-xl font-medium">Mbps</span></p>
                        <ul class="space-y-3 text-gray-600 mb-8 flex-grow text-left">
                            <li class="flex items-center"><i class="fas fa-users text-blue-500 mr-3"></i>Ideal untuk 3-5 orang</li>
                            <li class="flex items-center"><i class="fas fa-video text-blue-500 mr-3"></i>Video Conference</li>
                             <li class="flex items-center"><i class="fas fa-gamepad text-blue-500 mr-3"></i>Game Online Ringan</li>
                             <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Dukungan Teknis 24/7</li>
                        </ul>
                        <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20untuk%20berlangganan%20paket%20Boost%2015%20Mbps." class="w-full mt-auto text-center bg-blue-100 text-blue-700 font-bold py-3 rounded-lg hover:bg-blue-200 transition-colors">Pilih Paket</a>
                    </div>
                     <!-- Paket 20 Mbps -->
                    <div class="bg-white rounded-xl shadow-lg p-8 text-center flex flex-col border-2 border-blue-600 transform lg:scale-105 relative" data-aos="fade-up" data-aos-delay="300">
                         <p class="absolute top-0 right-1/2 translate-x-1/2 -translate-y-1/2 bg-blue-600 text-white text-xs font-bold px-3 py-1 rounded-full">Paling Populer</p>
                        <h3 class="text-2xl font-bold mb-2">Turbo</h3>
                        <p class="text-5xl font-extrabold text-blue-600 my-3">20 <span class="text-xl font-medium">Mbps</span></p>
                        <ul class="space-y-3 text-gray-600 mb-8 flex-grow text-left">
                           <li class="flex items-center"><i class="fas fa-users text-blue-500 mr-3"></i>Keluarga Besar</li>
                           <li class="flex items-center"><i class="fas fa-tv text-blue-500 mr-3"></i>Streaming 4K</li>
                           <li class="flex items-center"><i class="fas fa-cloud-upload-alt text-blue-500 mr-3"></i>Upload Konten</li>
                           <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Dukungan Teknis 24/7</li>
                        </ul>
                        <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20untuk%20berlangganan%20paket%20Turbo%2020%20Mbps." class="w-full mt-auto text-center bg-blue-600 text-white font-bold py-3 rounded-lg hover:bg-blue-700 transition-colors">Pilih Paket</a>
                    </div>
                     <!-- Paket 30 Mbps -->
                    <div class="bg-white rounded-xl shadow-lg p-8 text-center flex flex-col transition-all duration-300 hover:shadow-2xl hover:scale-105" data-aos="fade-up" data-aos-delay="400">
                        <h3 class="text-2xl font-bold mb-2">Velocity</h3>
                        <p class="text-5xl font-extrabold text-blue-600 my-3">30 <span class="text-xl font-medium">Mbps</span></p>
                        <ul class="space-y-3 text-gray-600 mb-8 flex-grow text-left">
                             <li class="flex items-center"><i class="fas fa-broadcast-tower text-blue-500 mr-3"></i>Kebutuhan Tinggi</li>
                             <li class="flex items-center"><i class="fas fa-gamepad text-blue-500 mr-3"></i>Game Online Berat</li>
                             <li class="flex items-center"><i class="fas fa-server text-blue-500 mr-3"></i>Multiple Streaming 4K</li>
                             <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Dukungan Teknis 24/7</li>
                        </ul>
                        <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20untuk%20berlangganan%20paket%20Velocity%2030%20Mbps." class="w-full mt-auto text-center bg-blue-100 text-blue-700 font-bold py-3 rounded-lg hover:bg-blue-200 transition-colors">Pilih Paket</a>
                    </div>
                </div>
            </div>
        </section>

        <!-- Kenapa Memilih Wireless -->
         <section class="py-20 bg-white">
            <div class="container mx-auto px-6">
                 <div class="text-center mb-12" data-aos="fade-up">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Kenapa Memilih Internet Wireless?</h2>
                    <p class="mt-4 text-lg text-gray-600 max-w-2xl mx-auto">Teknologi nirkabel memberikan berbagai keuntungan dibanding koneksi kabel konvensional.</p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                    <!-- Keuntungan 1 -->
                    <div class="text-center p-6" data-aos="fade-up" data-aos-delay="100">
                        <i class="fas fa-shipping-fast text-4xl text-blue-600 mb-4"></i>
                        <h3 class="text-xl font-bold mb-2">Instalasi Cepat & Mudah</h3>
                        <p class="text-gray-600">Tanpa perlu penarikan kabel fiber optik yang rumit, proses instalasi di tempat Anda menjadi jauh lebih cepat dan minim gangguan.</p>
                    </div>
                    <!-- Keuntungan 2 -->
                    <div class="text-center p-6" data-aos="fade-up" data-aos-delay="200">
                        <i class="fas fa-map-signs text-4xl text-blue-600 mb-4"></i>
                        <h3 class="text-xl font-bold mb-2">Jangkauan Lebih Luas</h3>
                        <p class="text-gray-600">Teknologi wireless mampu menjangkau area-area yang belum tercover oleh jaringan kabel, memberikan akses internet merata.</p>
                    </div>
                    <!-- Keuntungan 3 -->
                    <div class="text-center p-6" data-aos="fade-up" data-aos-delay="300">
                        <i class="fas fa-cloud-showers-heavy text-4xl text-blue-600 mb-4"></i>
                        <h3 class="text-xl font-bold mb-2">Tahan Gangguan Fisik</h3>
                        <p class="text-gray-600">Jaringan kami tidak rentan terhadap risiko kabel putus akibat galian atau faktor eksternal lainnya, sehingga koneksi lebih aman.</p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Q&A Section -->
        <section class="py-20 bg-gray-50 dot-pattern">
            <div class="container mx-auto px-6">
                <div class="text-center mb-12" data-aos="fade-up">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Pertanyaan Umum Broadband</h2>
                </div>
                <div class="max-w-3xl mx-auto" data-aos="fade-up" data-aos-delay="100">
                    <div class="space-y-4">
                        <!-- Q1 -->
                        <div class="qa-item bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                            <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-gray-800 focus:outline-none">
                                <span class="text-lg">Apa itu FUP dan apakah paket ini memilikinya?</span>
                                <i class="fas fa-plus text-blue-600"></i>
                            </button>
                            <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                                <div class="p-6 pt-0 text-gray-600">
                                    <p>FUP (Fair Usage Policy) adalah batas pemakaian wajar. Kami bangga menyatakan bahwa semua paket Broadband Wireless kami **sepenuhnya unlimited tanpa FUP**, jadi Anda bisa menggunakan internet sepuasnya tanpa khawatir kecepatan menurun.</p>
                                </div>
                            </div>
                        </div>
                        <!-- Q2 -->
                        <div class="qa-item bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                            <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-gray-800 focus:outline-none">
                                <span class="text-lg">Berapa banyak perangkat yang bisa terhubung?</span>
                                 <i class="fas fa-plus text-blue-600"></i>
                            </button>
                            <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                                <div class="p-6 pt-0 text-gray-600">
                                    <p>Paket Spark 10 Mbps ideal untuk hingga 7 perangkat, sementara paket Turbo 20 Mbps nyaman digunakan untuk lebih banyak perangkat secara bersamaan. Jumlah pastinya tergantung pada aktivitas masing-masing perangkat.</p>
                                </div>
                            </div>
                        </div>
                        <!-- Q3 -->
                        <div class="qa-item bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                            <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-gray-800 focus:outline-none">
                                <span class="text-lg">Apakah ada biaya tambahan untuk instalasi?</span>
                                 <i class="fas fa-plus text-blue-600"></i>
                            </button>
                            <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                                <div class="p-6 pt-0 text-gray-600">
                                   <p>Kami sering mengadakan promo gratis biaya instalasi. Untuk informasi promo terbaru mengenai biaya pemasangan, silakan hubungi tim marketing kami melalui WhatsApp atau telepon.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Final CTA -->
        <section class="py-20 bg-white">
            <div class="container mx-auto px-6">
                <div class="bg-blue-600 text-white rounded-2xl p-10 flex flex-col lg:flex-row items-center justify-between gap-8" data-aos="zoom-in">
                    <div class="lg:w-2/3 text-center lg:text-left">
                        <h2 class="text-3xl font-bold mb-3">Siap Menikmati Internet Cepat di Rumah?</h2>
                        <p class="text-blue-100">Hubungi kami sekarang untuk survey lokasi gratis dan pilih paket Broadband Wireless yang paling cocok untuk keluarga Anda.</p>
                    </div>
                    <div class="flex-shrink-0">
                        <a href="#" class="bg-white text-blue-700 font-bold px-8 py-4 rounded-lg hover:bg-gray-100 transition-colors transform hover:scale-105 shadow-lg inline-block">
                            Hubungi Kami Sekarang
                        </a>
                    </div>
                </div>
            </div>
        </section>
        
    </main>
    <script src="https://unpkg.com/aos@next/dist/aos.js"></script>
    <script>
        // Animate on Scroll Initialization
        AOS.init({
            duration: 800,
            once: true,
            offset: 50,
        });

        // Mobile menu toggle
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const mobileMenu = document.getElementById('mobile-menu');
        mobileMenuButton.addEventListener('click', () => {
            mobileMenu.classList.toggle('hidden');
            document.body.classList.toggle('overflow-hidden');
        });

        // Desktop dropdown toggle for Layanan
        const desktopLayananButton = document.getElementById('desktop-layanan-button');
        const desktopLayananMenu = document.getElementById('desktop-layanan-menu');
        const desktopLayananIcon = desktopLayananButton.querySelector('i');
        if(desktopLayananButton) {
            desktopLayananButton.addEventListener('click', (e) => {
                e.stopPropagation(); 
                desktopLayananMenu.classList.toggle('hidden');
                desktopLayananIcon.classList.toggle('rotate-180');
            });
        }
        document.addEventListener('click', (e) => {
            if (desktopLayananMenu && !desktopLayananMenu.classList.contains('hidden') && !desktopLayananButton.contains(e.target)) {
                desktopLayananMenu.classList.add('hidden');
                desktopLayananIcon.classList.remove('rotate-180');
            }
        });

        // Mobile dropdown toggle for Layanan
        const mobileLayananButton = document.getElementById('mobile-layanan-button');
        const mobileLayananMenu = document.getElementById('mobile-layanan-menu');
        const mobileLayananIcon = mobileLayananButton.querySelector('i');

        mobileLayananButton.addEventListener('click', (e) => {
            e.preventDefault();
            mobileLayananMenu.classList.toggle('hidden');
            mobileLayananIcon.classList.toggle('rotate-180');
        });


        // Q&A Accordion
        const qaItems = document.querySelectorAll('.qa-item');
        qaItems.forEach(item => {
            const question = item.querySelector('.qa-question');
            const answer = item.querySelector('.qa-answer');
            const icon = question.querySelector('i');

            question.addEventListener('click', () => {
                const isOpen = answer.style.maxHeight && answer.style.maxHeight !== '0px';

                // Close all other items
                qaItems.forEach(otherItem => {
                    if (otherItem !== item) {
                        otherItem.querySelector('.qa-answer').style.maxHeight = '0px';
                        const otherIcon = otherItem.querySelector('.qa-question i');
                        otherIcon.classList.remove('fa-minus');
                        otherIcon.classList.add('fa-plus');
                    }
                });

                // Open or close the clicked item
                if (isOpen) {
                    answer.style.maxHeight = '0px';
                    icon.classList.remove('fa-minus');
                    icon.classList.add('fa-plus');
                } else {
                    answer.style.maxHeight = answer.scrollHeight + 'px';
                    icon.classList.remove('fa-plus');
                    icon.classList.add('fa-minus');
                }
            });
        });

        // Floating Chat Widget
        const chatToggleButton = document.getElementById('chat-toggle');
        const chatOptions = document.getElementById('chat-options');
        const closeChatButton = document.getElementById('close-chat');
        const chatIconOpen = document.getElementById('chat-icon-open');
        const chatIconClose = document.getElementById('chat-icon-close');

        function toggleChat() {
            chatOptions.classList.toggle('hidden');
            chatIconOpen.classList.toggle('hidden');
            chatIconClose.classList.toggle('hidden');
        }

        if (chatToggleButton) {
            chatToggleButton.addEventListener('click', (e) => {
                e.stopPropagation();
                toggleChat();
            });
        }

        if (closeChatButton) {
            closeChatButton.addEventListener('click', () => {
                toggleChat();
            });
        }

        document.addEventListener('click', (e) => {
            if (!chatOptions.classList.contains('hidden') && !chatToggleButton.contains(e.target) && !chatOptions.contains(e.target)) {
                toggleChat();
            }
        });

        // Live Chat Logic
        const liveChatButton = document.getElementById('live-chat-button');
        liveChatButton.addEventListener('click', (e) => {
             e.preventDefault();
             window.open('live-chat.html', 'live-chat', 'width=400,height=600');
        });
    </script>

</body>
</html>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('index', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/lab-mji/Pictures/new/mji_isp/resources/views/broadband.blade.php ENDPATH**/ ?>