<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'MAJUIN - Internet Wireless Cepat & Stabil'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <link rel="stylesheet" href="https://unpkg.com/aos@next/dist/aos.css" />
    <script src="https://unpkg.com/typeit@8.7.1/dist/index.umd.js"></script>
    <link rel="shortcut icon" href="<?php echo e(asset('aset/favicon.ico')); ?>">
    <?php echo $__env->yieldPushContent('styles'); ?>
    <style>
        html, body {
            width: 100%;
            overflow-x: hidden;
            font-family: 'Inter', sans-serif;
        }
        .dot-pattern {
            background-image: radial-gradient(circle at 1px 1px, rgba(0,0,0,0.04) 1px, transparent 0);
            background-size: 25px 25px;
        }
        .qa-question i, #mobile-layanan-button i, #desktop-layanan-button i {
            transition: transform 0.3s ease;
        }
        .rotate-180 {
            transform: rotate(180deg);
        }
        #chat-options {
            transition: opacity 0.3s ease-out, transform 0.3s ease-out;
        }
    </style>
</head>
<body class="bg-white text-gray-800">

    <!-- Top Bar -->
    <div class="hidden md:block bg-gray-100 border-b border-gray-200 text-sm text-gray-600">
        <div class="container mx-auto px-6 py-2 flex justify-between items-center">
            <!-- Social Icons -->
            <div class="flex items-center space-x-4">
                <a href="#" class="hover:text-blue-600 transition-colors"><i class="fab fa-facebook-f"></i></a>
                <a href="https://www.instagram.com/majuin_shop" class="hover:text-blue-600 transition-colors"><i class="fab fa-instagram"></i></a>
                <a href="https://www.youtube.com/@majuin.onlineshop" class="hover:text-blue-600 transition-colors"><i class="fab fa-youtube"></i></a>
                <a href="https://www.tiktok.com/@majuinonlineshop" class="hover:text-blue-600 transition-colors"><i class="fab fa-tiktok"></i></a>
            </div>
            <!-- Contact Info & Links -->
            <div class="flex items-center space-x-6">
                <a href="mailto:salam@majuin.co.id" class="flex items-center gap-2 hover:text-blue-600 transition-colors">
                    <i class="fas fa-envelope"></i>
                    <span>salam@majuin.co.id</span>
                </a>
                <a href="#" class="hover:text-blue-600 transition-colors font-medium">Support</a>
                <a href="#" class="hover:text-blue-600 transition-colors font-medium">Career</a>
            </div>
        </div>            
    </div>

    <!-- Header & Navigasi -->
    <header class="bg-white shadow-sm fixed top-0 left-0 w-full z-50">
        <nav class="container mx-auto px-6 py-4 flex justify-between items-center">
            <a href="<?php echo e(url('/')); ?>" class="text-3xl font-bold text-blue-600">
                <img src="<?php echo e(asset('aset/logo.png')); ?>" alt="Logo Majuin" class="h-8" style="width: 160px; height: auto;">
            </a>
            <div class="hidden lg:flex items-center justify-end flex-1 space-x-8">
                <a href="<?php echo e(url('/')); ?>" class="<?php echo e(request()->is('/') ? 'text-blue-600 font-bold' : 'text-gray-600 hover:text-blue-600 font-medium'); ?>">Beranda</a>
                <a href="<?php echo e(url('/tentang')); ?>" class="<?php echo e(request()->is('tentang') ? 'text-blue-600 font-bold' : 'text-gray-600 hover:text-blue-600 font-medium'); ?>">Tentang</a>
                <div class="relative">
                    <button id="desktop-layanan-button" class="<?php echo e(request()->is('layanan*') ? 'text-blue-600 font-bold' : 'text-gray-600 hover:text-blue-600 font-medium'); ?> inline-flex items-center">
                        <a href="<?php echo e(url('/layanan')); ?>" class="inline-block">Layanan</a><i class="fas fa-chevron-down ml-2 text-xs"></i>
                    </button>
                    <div id="desktop-layanan-menu" class="absolute z-10 hidden bg-white shadow-lg rounded-lg mt-2 w-60 py-2 transition-all duration-300">
                        <a href="<?php echo e(url('/broadband')); ?>" class="block px-4 py-2 text-gray-600 hover:bg-gray-100 hover:text-blue-600">Broadband Wireless</a>
                        <a href="<?php echo e(url('/dedicated')); ?>" class="block px-4 py-2 text-gray-600 hover:bg-gray-100 hover:text-blue-600">Dedicated Wireless</a>
                    </div>
                </div>

                <a href="<?php echo e(url('/kontak')); ?>" class="<?php echo e(request()->is('kontak') ? 'text-blue-600 font-bold' : 'text-gray-600 hover:text-blue-600 font-medium'); ?>">Kontak</a>
                <a href="https://wa.me/62817228297?text=Halo" target="_blank" rel="noopener noreferrer" class="bg-blue-600 text-white px-6 py-2.5 rounded-lg font-semibold hover:bg-blue-700 transition-colors">Daftar Sekarang</a>
            </div>
            <button id="mobile-menu-button" class="lg:hidden ml-4">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16m-7 6h7"></path></svg>
            </button>
        </nav>
        <!-- Mobile Menu -->
        <div id="mobile-menu" class="hidden lg:hidden px-6 pt-2 pb-4 space-y-2">
            <a href="<?php echo e(url('/')); ?>" class="block <?php echo e(request()->is('/') ? 'text-blue-600 font-bold' : 'text-gray-600 hover:text-blue-600'); ?>">Beranda</a>
            <a href="<?php echo e(url('/tentang')); ?>" class="block <?php echo e(request()->is('tentang') ? 'text-blue-600 font-bold' : 'text-gray-600 hover:text-blue-600'); ?>">Tentang</a>
            
            <div>
                <button id="mobile-layanan-button" class="w-full text-left flex justify-between items-center <?php echo e(request()->is('layanan*') ? 'text-blue-600 font-bold' : 'text-gray-600 hover:text-blue-600'); ?> font-medium py-2">
                    Layanan
                    <i class="fas fa-chevron-down text-xs"></i>
                </button>
                <div id="mobile-layanan-menu" class="hidden pl-4 pt-2 space-y-2">
                    <a href="<?php echo e(url('/broadband')); ?>" class="block text-gray-600 hover:text-blue-600">Broadband Wireless</a>
                    <a href="<?php echo e(url('/dedicated')); ?>" class="block text-gray-600 hover:text-blue-600">Dedicated Wireless</a>

                </div>
            </div>
          
            <a href="<?php echo e(url('/kontak')); ?>" class="block <?php echo e(request()->is('kontak') ? 'text-blue-600 font-bold' : 'text-gray-600 hover:text-blue-600'); ?>">Kontak</a>
            <a href="https://wa.me/62817228297?text=Halo" target="_blank" rel="noopener noreferrer" class="block bg-blue-600 text-white text-center mt-2 px-5 py-2 rounded-lg hover:bg-blue-700 transition-colors">Hubungi Marketing</a>
        </div>
    </header>

    <main class="pt-28">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="bg-slate-900 text-gray-300">
        <div class="container mx-auto px-6 pt-16 pb-8">
            <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-5 gap-12 mb-12">
                <div class="col-span-2 lg:col-span-1">
                    <img src="<?php echo e(asset('aset/logo2.png')); ?>" alt="Logo Majuin" class="h-8 mb-4" style="width: 160px; height: auto;">
                    <p class="text-slate-400 text-sm mb-6">
                        Penyedia layanan internet wireless yang berkomitmen menghadirkan koneksi cepat, stabil, dan unlimited.
                    </p>
                </div>
                <div>
                    <h4 class="font-semibold text-white mb-4">Layanan</h4>
                    <ul class="space-y-2 text-sm">
                        <li><a href="<?php echo e(url('/broadband')); ?>" class="text-slate-400 hover:text-white hover:underline">Internet Broadband Wireless</a></li>
                        <li><a href="<?php echo e(url('/dedicated')); ?>" class="text-slate-400 hover:text-white hover:underline">Internet Dedicated Wireless</a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="font-semibold text-white mb-4">Informasi</h4>
                    <ul class="space-y-2 text-sm">
                       <li><a href="<?php echo e(url('/')); ?>" class="text-slate-400 hover:text-white hover:underline">Beranda</a></li>
                       <li><a href="<?php echo e(url('/tentang')); ?>" class="text-slate-400 hover:text-white hover:underline">Tentang Kami</a></li>
                       <li><a href="<?php echo e(url('/kontak')); ?>" class="text-slate-400 hover:text-white hover:underline">Kontak</a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="font-semibold text-white mb-4">Media Sosial</h4>
                     <ul class="space-y-2 text-sm">
                        <li><a href="#" class="text-slate-400 hover:text-white hover:underline">Facebook</a></li>
                        <li><a href="#" class="text-slate-400 hover:text-white hover:underline">Instagram</a></li>
                        <li><a href="#" class="text-slate-400 hover:text-white hover:underline">Twitter</a></li>
                        <li><a href="#" class="text-slate-400 hover:text-white hover:underline">TikTok</a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="font-semibold text-white mb-4">Kantor</h4>
                    <address class="not-italic text-sm text-slate-400 space-y-2">
                        <p>Bumi mutiara Indah No.D10, RT.2/RW.7, Kompa, Parungkuda, Sukabumi Regency, West Java 43357</p>
                        <p>0817228297</p>
                    </address>
                </div>
            </div>
            <div class="pt-8 border-t border-slate-700 flex flex-col md:flex-row justify-between items-center text-sm">
                <p class="text-slate-500 mb-4 md:mb-0">Copyright 2025 PT Maintek Juara Intisolusi. All Rights Reserved</p>
            </div>
        </div>
    </footer>
    
    <!-- Floating Chat Widget -->
    <div class="fixed bottom-6 right-6 z-50">
        <div id="chat-options" class="hidden absolute bottom-full mb-2 right-0 w-64 sm:w-72 bg-white rounded-lg shadow-2xl p-4 transition-all duration-300 ease-out origin-bottom-right">
            <div class="flex justify-between items-center mb-4 pb-2 border-b">
                <h4 class="font-bold text-gray-800">Hubungi Kami</h4>
                <button id="close-chat" class="text-gray-400 hover:text-gray-800 text-2xl">&times;</button>
            </div>
            <a href="https://wa.me/62817228297?text=Halo%20MAJUIN,%20saya%20ingin%20bertanya." target="_blank" rel="noopener noreferrer" class="flex items-center p-3 hover:bg-gray-100 rounded-lg">
                <i class="fab fa-whatsapp text-3xl text-green-500 mr-4"></i>
                <div>
                    <p class="font-semibold text-gray-800">Chat via WhatsApp</p>
                    <p class="text-xs text-gray-500">Respon Cepat</p>
                </div>
            </a>
            <a href="chatbot.html" target="_blank" id="live-chat-button" class="flex items-center p-3 mt-2 hover:bg-gray-100 rounded-lg">
                <i class="fas fa-comment-dots text-3xl text-blue-500 mr-4"></i>
                <div>
                    <p class="font-semibold text-gray-800">Chat Langsung</p>
                </div>
            </a>
        </div>
        <button id="chat-toggle" class="bg-blue-600 text-white w-16 h-16 rounded-full flex items-center justify-center shadow-2xl transform transition-transform hover:scale-110">
            <i id="chat-icon-open" class="fas fa-comment-dots text-3xl"></i>
            <i id="chat-icon-close" class="fas fa-times text-3xl hidden"></i>
        </button>
    </div>
    
    <script src="https://unpkg.com/aos@next/dist/aos.js"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
    <script>
        AOS.init({
            duration: 800,
            once: true,
            offset: 50,
        });

        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const mobileMenu = document.getElementById('mobile-menu');
        mobileMenuButton.addEventListener('click', () => {
            mobileMenu.classList.toggle('hidden');
            document.body.classList.toggle('overflow-hidden');
        });

        const desktopLayananButton = document.getElementById('desktop-layanan-button');
        const desktopLayananMenu = document.getElementById('desktop-layanan-menu');
        const desktopLayananIcon = desktopLayananButton.querySelector('i');
        if(desktopLayananButton) {
            desktopLayananButton.addEventListener('click', (e) => {
                e.stopPropagation(); 
                desktopLayananMenu.classList.toggle('hidden');
                desktopLayananIcon.classList.toggle('rotate-180');
            });
        }
        document.addEventListener('click', (e) => {
            if (desktopLayananMenu && !desktopLayananMenu.classList.contains('hidden') && !desktopLayananButton.contains(e.target)) {
                desktopLayananMenu.classList.add('hidden');
                desktopLayananIcon.classList.remove('rotate-180');
            }
        });

        const mobileLayananButton = document.getElementById('mobile-layanan-button');
        const mobileLayananMenu = document.getElementById('mobile-layanan-menu');
        const mobileLayananIcon = mobileLayananButton.querySelector('i');

        mobileLayananButton.addEventListener('click', (e) => {
            e.preventDefault();
            mobileLayananMenu.classList.toggle('hidden');
            mobileLayananIcon.classList.toggle('rotate-180');
        });

        const chatToggleButton = document.getElementById('chat-toggle');
        const chatOptions = document.getElementById('chat-options');
        const closeChatButton = document.getElementById('close-chat');
        const chatIconOpen = document.getElementById('chat-icon-open');
        const chatIconClose = document.getElementById('chat-icon-close');

        function toggleChat() {
            chatOptions.classList.toggle('hidden');
            chatIconOpen.classList.toggle('hidden');
            chatIconClose.classList.toggle('hidden');
        }

        if (chatToggleButton) {
            chatToggleButton.addEventListener('click', (e) => {
                e.stopPropagation();
                toggleChat();
            });
        }

        if (closeChatButton) {
            closeChatButton.addEventListener('click', () => {
                toggleChat();
            });
        }

        document.addEventListener('click', (e) => {
            if (!chatOptions.classList.contains('hidden') && !chatToggleButton.contains(e.target) && !chatOptions.contains(e.target)) {
                toggleChat();
            }
        });

        const liveChatButton = document.getElementById('live-chat-button');
        liveChatButton.addEventListener('click', (e) => {
             e.preventDefault();
             window.open('chatbot.html', 'live-chat', 'width=400,height=600');
        });
    </script>
</body>
</html>
<?php /**PATH /home/lab-mji/Pictures/new/mji_isp/resources/views/layouts/app.blade.php ENDPATH**/ ?>